//
//  NOVDDataSource.h
//  NSOutlineView Demo
//
//  Created by David John Burrowes on 4/26/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "NOVDDataSource.h"
#import "NOVDTreeNode.h"

@interface NOVDDataSource : NSObject {
	NOVDTreeNode* myRoot;
}

- init;
- (void) dealloc;

- (BOOL)outlineView:(NSOutlineView *)outlineView
	acceptDrop:(id <NSDraggingInfo>)info
	item:(id)item childIndex:(int)index;

- (id)outlineView:(NSOutlineView *)outlineView
	child:(int)index ofItem:(id)item;

- (BOOL)outlineView:(NSOutlineView *)outlineView
	isItemExpandable:(id)item;

- (id)outlineView:(NSOutlineView *)outlineView
	itemForPersistentObject:(id)object;

- (int)outlineView:(NSOutlineView *)outlineView
	numberOfChildrenOfItem:(id)item;

- (id)outlineView:(NSOutlineView *)outlineView
	objectValueForTableColumn:(NSTableColumn *)tableColumn
	byItem:(id)ite;

- (id)outlineView:(NSOutlineView *)outlineView
	persistentObjectForItem:(id)item;

- (void)outlineView:(NSOutlineView *)outlineView
	setObjectValue:(id)object
	forTableColumn:(NSTableColumn *)tableColumn
	byItem:(id)item;

- (void)outlineView:(NSOutlineView *)outlineView
	sortDescriptorsDidChange:(NSArray *)oldDescriptors;

- (NSDragOperation)outlineView:(NSOutlineView *)outlineView
	validateDrop:(id <NSDraggingInfo>)info
	proposedItem:(id)item
	proposedChildIndex:(int)index;

- (BOOL)outlineView:(NSOutlineView *)outlineView
	writeItems:(NSArray *)items
	toPasteboard:(NSPasteboard *)pboard;



@end
